
//******************************************
//Stack Pointer	=	0x43f (If use MQ6833_x_startup.asm)
//Ram range = 0x240~0x43f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6833.h"


#define TEST_Signal_Width_L 0x34
#define TEST_Signal_Width_H 0x01
#define TEST_Signal_Period_L 0x34
#define TEST_Signal_Period_H 0x02


void main()
{

	P7FC.bit.b1 = 1;
	P7CR.bit.b1 = 1;	//set PPG1 for test signal
	P7CR.bit.b2 = 0;	//TCA0 input
	P0CR.bit.b0 = 1;	//set P00 output for response signal
	P0CR.bit.b1	= 1;	//set P01 output for response signal

	__asm("DI");
	POFFCR0.byte = 0x11;
	EIRH.bit.b6 = 1;
	__asm("EI");
	//=================
	// set PPG input signal
	// for testing Pulsewidth Measurement Mode
	//
	// ================
	T001CR.bit.b2 = 1;
	T01MOD.byte = 0xC3;	//TFF =1,double buffer,sck = fcgck/2^11,16-bit PPG mode
	T00PWM.byte = TEST_Signal_Width_L;
	T01PWM.byte = TEST_Signal_Width_H;
	T00REG.byte = TEST_Signal_Period_L;
	T01REG.byte = TEST_Signal_Period_H;


	//=================
	// set Pulsewidth Measurement Mode
	//
	//
	// ================
	TA0CR.byte = 0xc0;	//enable Overflow interrupt,TFF=1,no noise canceller

	TA0MOD.byte = 0x86;	//double buffer,double edge capture,sck=fcgck/2^10,
						//Pulse width measurement mode
	//=================
	// start Pulsewidth Measurement Mode
	// ================
	TA0CR.bit.b0= 1;
	//=================
	// start PPG
	// ================
	T001CR.bit.b1 = 1;

	while(1)
	{}


}








